
<?php $__env->startSection('title', 'Tarix'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .image-grid img {
        max-width: 100px;
        margin: 5px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        cursor: pointer;
        transition: transform 0.2s;
    }
    .image-grid img:hover {
        transform: scale(1.05);
    }
    #fullscreen-image {
        max-width: 100%;
        max-height: 80vh;
        object-fit: contain;
    }
    .pagination .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-text);
        border-color: var(--border-color);
        transition: background-color 0.2s, color 0.2s;
    }
    .pagination .page-link:hover {
        background-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.active .page-link {
        background-color: var(--pagination-active-bg);
        border-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.disabled .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-disabled);
        border-color: var(--border-color);
    }
</style>

<div class="container mt-4">
    <div class="card" style="background-color: var(--card-bg); border: 1px solid var(--border-color);">
        <div class="card-header">
            <h5 class="mb-0" style="color: var(--text-color);">Barcha amaliyotlar tarixi</h5>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert" style="background-color: var(--alert-success-bg); color: var(--text-color);">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert" style="background-color: var(--alert-danger-bg); color: var(--text-color);">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php $__empty_1 = true; $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="card mb-2 history-card" data-bs-toggle="modal" data-bs-target="#historyModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>" data-history-id="<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>">
                    <div class="card-body p-3" style="cursor: pointer;">
                        <div class="d-flex align-items-center">
                            <img src="<?php echo e(asset('assets/icons/' . ($item->source_table == 'transactions' ? ($item->type == 'income' ? 'income.png' : ($item->type == 'product_return' ? 'product_return.png' : 'expense.png')) : ($item->type == 'payment_to_supplier' ? 'payment_to_supplier.png' : 'product_payment.png')))); ?>" alt="Icon" style="width: 24px; height: 24px; margin-right: 12px;">
                            <div>
                                <strong style="color: var(--text-color);">
                                    <?php if($item->source_table == 'transactions'): ?>
                                        <?php echo e($item->type == 'income' ? 'Kirim' : ($item->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat')); ?>

                                    <?php else: ?>
                                        <?php echo e($item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi'); ?>

                                    <?php endif; ?>
                                    <?php if($item->is_cancelled): ?>
                                        <span class="badge bg-danger">Bekor qilindi</span>
                                    <?php endif; ?>
                                </strong>
                                <div class="<?php echo e($item->amount >= 0 ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e(number_format(abs($item->amount), 2, '.', ' ')); ?> so‘m
                                </div>
                                <small class="text-muted" style="color: var(--text-muted);">
                                    <?php echo e($item->created_at->format('d.m.Y H:i')); ?>

                                    <?php if($item->user): ?>
                                        | <?php echo e($item->user->name); ?>

                                    <?php endif; ?>
                                    <?php if($item->source_table == 'transactions' && $item->category): ?>
                                        | <?php echo e($item->category->name); ?>

                                    <?php endif; ?>
                                    <?php if($item->source_table == 'payments' && $item->supplier): ?>
                                        | <?php echo e($item->supplier->name); ?>

                                    <?php endif; ?>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Modal -->
                <div class="modal fade" id="historyModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="historyModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>" aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                            <div class="modal-header">
                                <h5 class="modal-title" id="historyModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>" style="color: var(--text-color);">
                                    <?php if($item->source_table == 'transactions'): ?>
                                        <?php echo e($item->type == 'income' ? 'Kirim' : ($item->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat')); ?>

                                    <?php else: ?>
                                        <?php echo e($item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi'); ?>

                                    <?php endif; ?>
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body" style="color: var(--text-color);">
                                <p><strong>Sana:</strong> <?php echo e($item->created_at->format('d.m.Y H:i')); ?></p>
                                <p><strong>Summa:</strong> <?php echo e(number_format(abs($item->amount), 2, '.', ' ')); ?> so‘m</p>
                                <p><strong>Manba:</strong> <?php echo e($item->source == 'cash' ? 'Naqd' : 'Karta'); ?></p>
                                <?php if($item->source_table == 'transactions' && $item->category): ?>
                                    <p><strong>Kategoriya:</strong> <?php echo e($item->category->name); ?></p>
                                <?php endif; ?>
                                <?php if($item->source_table == 'payments' && $item->supplier): ?>
                                    <p><strong>Yetkazib beruvchi:</strong> <?php echo e($item->supplier->name); ?></p>
                                <?php endif; ?>
                                <?php if($item->source_table == 'transactions' && $item->supplier): ?>
                                    <p><strong>Yetkazib beruvchi:</strong> <?php echo e($item->supplier->name); ?></p>
                                <?php endif; ?>
                                <p><strong>Izoh:</strong> <?php echo e($item->description ?? 'Izoh yo‘q'); ?></p>
                                <p><strong>Rasmlar:</strong>
                                    <?php
                                        $images = $item->images ? json_decode($item->images, true) : [];
                                    ?>
                                    <?php if(!empty($images) && is_array($images)): ?>
                                        <div class="image-grid d-flex flex-wrap">
                                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <img src="<?php echo e(asset('storage/' . $image)); ?>" alt="Rasm" data-bs-toggle="modal" data-bs-target="#fullscreenModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>">
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php else: ?>
                                        Rasm yuklanmagan
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="modal-footer">
                                <?php if(auth()->user()->isAdmin() && !$item->is_cancelled): ?>
                                    <?php if($item->source_table == 'transactions' && $item->type != 'income' && $item->type != 'product_return'): ?>
                                        <form action="<?php echo e(route('transactions.cancel', $item->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('POST'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    <?php elseif($item->source_table == 'payments'): ?>
                                        <form action="<?php echo e(route('payments.cancel', $item->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('POST'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
                    $images = $item->images ? json_decode($item->images, true) : [];
                ?>
                <?php if(!empty($images) && is_array($images)): ?>
                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modal fade" id="fullscreenModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>" tabindex="-1" aria-labelledby="fullscreenModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>" aria-hidden="true">
                            <div class="modal-dialog modal-fullscreen-sm-down">
                                <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="fullscreenModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>" style="color: var(--text-color);">Rasm</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <img id="fullscreen-image" src="<?php echo e(asset('storage/' . $image)); ?>" alt="Rasm">
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center" style="color: var(--text-color);">Hozircha amaliyotlar yo‘q</div>
            <?php endif; ?>

            <div class="mt-3 d-flex justify-content-center">
                <?php echo e($results->links('pagination::bootstrap-5')); ?>

            </div><br><br><br>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    // Initialize Bootstrap modals and store instances
    const modals = document.querySelectorAll('.modal');
    const modalInstances = new Map();

    modals.forEach(modal => {
        modalInstances.set(modal.id, new bootstrap.Modal(modal, { backdrop: true, keyboard: true }));
        
        // Log modal open events for debugging
        modal.addEventListener('shown.bs.modal', () => {
            console.log(`Modal ${modal.id} opened`);
        });

        // Handle modal close to ensure proper cleanup
        modal.addEventListener('hidden.bs.modal', () => {
            console.log(`Modal ${modal.id} closed`);
            
            // Clean up modal backdrop and body classes
            const backdrops = document.querySelectorAll('.modal-backdrop');
            backdrops.forEach(backdrop => backdrop.remove());
            document.body.classList.remove('modal-open');
            document.body.style.overflow = '';
            document.body.style.paddingRight = '';

            // Reset modal state
            modal.removeAttribute('aria-hidden');
            modal.removeAttribute('aria-modal');
            modal.style.display = '';
            modal.classList.remove('show');

            // Restore focus and re-enable historyModal card
            let historyModalId = modal.id;
            if (modal.id.includes('fullscreenModal')) {
                historyModalId = modal.id.replace(/fullscreenModal/, 'historyModal').replace(/_\d+$/, '');
                const historyModal = document.getElementById(historyModalId);
                if (historyModal) {
                    historyModal.removeAttribute('aria-hidden');
                    historyModal.removeAttribute('aria-modal');
                    historyModal.style.display = '';
                    historyModal.classList.remove('show');
                    console.log(`Reset state for ${historyModalId}`);
                }
            }

            const relatedCard = document.querySelector(`[data-bs-target="#${historyModalId}"]`);
            if (relatedCard) {
                // Reinitialize Bootstrap Modal for historyModal to ensure it can be reopened
                if (historyModalId.includes('historyModal')) {
                    modalInstances.set(historyModalId, new bootstrap.Modal(document.getElementById(historyModalId), { backdrop: true, keyboard: true }));
                }
                relatedCard.focus();
                console.log(`Focus restored and modal reinitialized for ${historyModalId}`);
            } else {
                document.body.focus();
                console.log('Focus restored to body');
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/festasystems/paypul.datamax.uz/resources/views/history/index.blade.php ENDPATH**/ ?>