<!-- Income Category Modal -->
<div class="modal fade" id="category-input-income-modal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="categoryModalLabel">Kategoriyani tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php $__currentLoopData = $incomeCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="category-input-income" data-value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Income Source Modal -->
<div class="modal fade" id="source-input-income-modal" tabindex="-1" aria-labelledby="sourceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sourceModalLabel">Manbani tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-income" data-value="cash">Naqd</button>
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-income" data-value="card">Karta</button>
            </div>
        </div>
    </div>
</div>

<!-- Expense Category Modal -->
<div class="modal fade" id="category-input-expense-modal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="categoryModalLabel">Kategoriyani tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php $__currentLoopData = $expenseCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="category-input-expense" data-value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Expense Source Modal -->
<div class="modal fade" id="source-input-expense-modal" tabindex="-1" aria-labelledby="sourceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sourceModalLabel">Manbani tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-expense" data-value="cash">Naqd</button>
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-expense" data-value="card">Karta</button>
            </div>
        </div>
    </div>
</div>

<!-- Payment to Supplier Modal -->
<div class="modal fade" id="supplier-input-payment-to-supplier-modal" tabindex="-1" aria-labelledby="supplierModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="supplierModalLabel">Yetkazib beruvchini tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="supplier-input-payment-to-supplier" data-value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Payment to Supplier Source Modal -->
<div class="modal fade" id="source-input-payment-to-supplier-modal" tabindex="-1" aria-labelledby="sourceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sourceModalLabel">Manbani tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-payment-to-supplier" data-value="cash">Naqd</button>
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-payment-to-supplier" data-value="card">Karta</button>
            </div>
        </div>
    </div>
</div>

<!-- Product Payment Supplier Modal -->
<div class="modal fade" id="supplier-input-product-payment-modal" tabindex="-1" aria-labelledby="supplierModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="supplierModalLabel">Yetkazib beruvchini tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="supplier-input-product-payment" data-value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Product Payment Source Modal -->
<div class="modal fade" id="source-input-product-payment-modal" tabindex="-1" aria-labelledby="sourceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sourceModalLabel">Manbani tanlang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-product-payment" data-value="cash">Naqd</button>
                <button type="button" class="btn btn-outline-secondary w-100 mb-2 option-btn" data-target="source-input-product-payment" data-value="card">Karta</button>
            </div>
        </div>
    </div>
</div>

<!-- Transaction Detail Modal -->
<?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="transactionModal<?php echo e($result->id); ?>" tabindex="-1" aria-labelledby="transactionModalLabel<?php echo e($result->id); ?>" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="transactionModalLabel<?php echo e($result->id); ?>">Amaliyot tafsilotlari</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><strong>Turi:</strong> 
                        <?php echo e($result->type == 'income' ? 'Kirim' : 
                           ($result->type == 'expense' ? 'Xarajat' : 
                           ($result->type == 'payment_to_supplier' ? 'Yetkazuvchi to‘lovi' : 'Mahsulot kirimi'))); ?>

                    </p>
                    <p><strong>Summa:</strong> <?php echo e(number_format($result->amount, 2)); ?> so‘m</p>
                    <p><strong>Manba:</strong> <?php echo e($result->source == 'cash' ? 'Naqd' : 'Karta'); ?></p>
                    <p><strong>Kategoriya/Yetkazuvchi:</strong> <?php echo e($result->related_entity); ?></p>
                    <p><strong>Izoh:</strong> <?php echo e($result->description ?? 'Yo‘q'); ?></p>
                    <p><strong>Foydalanuvchi:</strong> <?php echo e($result->user_name); ?></p>
                    <p><strong>Sana:</strong> <?php echo e($result->created_at->format('d.m.Y H:i')); ?></p>
                    <p><strong>Rasmlar:</strong></p>
                    <?php if($result->images): ?>
                        <?php $__currentLoopData = json_decode($result->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(asset('storage/' . $image)); ?>" target="_blank">
                                <img src="<?php echo e(asset('storage/' . $image)); ?>" alt="Image" width="100" class="mb-2">
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>Rasmlar yo‘q</p>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php /**PATH /home/festasystems/paypul.datamax.uz/resources/views/modals.blade.php ENDPATH**/ ?>