
<?php $__env->startSection('title', 'Yetkazib beruvchi tafsilotlari'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .image-grid img {
        max-width: 100px;
        margin: 5px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        cursor: pointer;
        transition: transform 0.2s;
    }
    .image-grid img:hover {
        transform: scale(1.05);
    }
    #fullscreen-image {
        max-width: 100%;
        max-height: 80vh;
        object-fit: contain;
    }
    .pagination .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-text);
        border-color: var(--border-color);
        transition: background-color 0.2s, color 0.2s;
    }
    .pagination .page-link:hover {
        background-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.active .page-link {
        background-color: var(--pagination-active-bg);
        border-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.disabled .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-disabled);
        border-color: var(--border-color);
    }
    .phone-link {
        color: var(--text-color);
        text-decoration: none;
    }
    .phone-link:hover {
        text-decoration: underline;
        color: var(--pagination-active-bg);
    }
</style>

<div class="container mt-4">
    <div class="card" style="background-color: var(--card-bg); border: 1px solid var(--border-color);">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0" style="color: var(--text-color);">Yetkazib beruvchi tafsilotlari</h5>
            <div>
                <?php if(auth()->user()->isAdmin() || auth()->user()->id == $supplier->user_id): ?>
                    <a href="<?php echo e(route('suppliers.edit', $supplier->id)); ?>" class="btn btn-primary btn-sm" style="background-color: var(--button-bg); color: var(--input-text); border: none;">Tahrirlash</a>
                <?php endif; ?>
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#returnProductModal" style="background-color: var(--button-bg); color: var(--input-text); border: none;">Mahsulotni qaytarish</button>
            </div>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert" style="background-color: var(--alert-success-bg); color: var(--text-color);">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert" style="background-color: var(--alert-danger-bg); color: var(--text-color);">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="mb-3">
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Nomi:</strong> <?php echo e($supplier->name); ?></p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Telefon:</strong> 
                    <?php if($supplier->phone): ?>
                        <a href="tel:<?php echo e($supplier->phone); ?>" class="phone-link"><?php echo e($supplier->phone); ?></a>
                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Qarz holati:</strong>
                    <?php if($supplier->debt_balance == 0): ?>
                        Qarz yo‘q
                    <?php elseif($supplier->debt_balance > 0): ?>
                        <?php echo e(number_format($supplier->debt_balance, 2, '.', ' ')); ?> so‘m
                    <?php else: ?>
                        <?php echo e(number_format(abs($supplier->debt_balance), 2, '.', ' ')); ?> so‘m
                    <?php endif; ?>
                </p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Biriktirilgan:</strong> <?php echo e($supplier->user->name ?? 'N/A'); ?></p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Yaratilgan sana:</strong> <?php echo e($supplier->created_at->format('d.m.Y H:i')); ?></p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Yangilangan sana:</strong> <?php echo e($supplier->updated_at->format('d.m.Y H:i')); ?></p>
            </div>

            <div class="modal fade" id="returnProductModal" tabindex="-1" aria-labelledby="returnProductModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                        <div class="modal-header">
                            <h5 class="modal-title" id="returnProductModalLabel" style="color: var(--text-color);">Mahsulotni qaytarish</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="<?php echo e(route('suppliers.return-product', $supplier->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="amount" class="form-label" style="color: var(--text-color);">Qaytariladigan summa (so‘m):</label>
                                    <input type="number" class="form-control" id="amount" name="amount" step="0.01" min="0.01" max="1000000" required style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);">
                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="description" class="form-label" style="color: var(--text-color);">Izoh:</label>
                                    <textarea class="form-control" id="description" name="description" rows="4" style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);"></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="images" class="form-label" style="color: var(--text-color);">Rasmlar (maksimum 5 ta):</label>
                                    <input type="file" class="form-control" id="images" name="images[]" accept="image/jpeg,image/png,image/jpg" multiple style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);">
                                    <?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                <button type="submit" class="btn btn-primary">Saqlash</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <?php if($operations->isNotEmpty()): ?>
                <h5 style="color: var(--text-color);">Amaliyotlar tarixi</h5>
                <?php $__currentLoopData = $operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card mb-2" style="background-color: var(--card-bg); border-color: var(--border-color);" data-bs-toggle="modal" data-bs-target="#operationModal<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>">
                        <div class="card-body p-3 d-flex align-items-center" style="cursor: pointer;">
                            <img src="<?php echo e(asset('assets/icons/' . ($operation->source_table == 'transactions' ? ($operation->type == 'product_return' ? 'product_return.png' : 'expense.png') : ($operation->type == 'payment_to_supplier' ? 'payment_to_supplier.png' : 'product_payment.png')))); ?>" alt="Icon" style="width: 24px; height: 24px; margin-right: 12px;">
                            <div>
                                <strong style="color: var(--text-color);">
                                    <?php if($operation->source_table == 'transactions'): ?>
                                        <?php echo e($operation->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat'); ?>

                                    <?php else: ?>
                                        <?php echo e($operation->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi'); ?>

                                    <?php endif; ?>
                                    <?php if($operation->source_table == 'payments' && $operation->is_cancelled): ?>
                                        <span class="badge bg-danger">Bekor qilindi</span>
                                    <?php endif; ?>
                                </strong>
                                <div class="<?php echo e($operation->amount >= 0 ? 'text-success' : 'text-danger'); ?>" style="color: <?php echo e($operation->amount >= 0 ? 'var(--success-color)' : 'var(--danger-color)'); ?>;">
                                    <?php echo e(number_format(abs($operation->amount), 2, '.', ' ')); ?> so‘m
                                </div>
                                <small class="text-muted" style="color: var(--text-muted);">
                                    <?php echo e($operation->created_at->format('d.m.Y H:i')); ?>

                                    <?php if($operation->user): ?>
                                        | <?php echo e($operation->user->name); ?>

                                    <?php endif; ?>
                                </small>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="operationModal<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>" tabindex="-1" aria-labelledby="operationModalLabel<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="operationModalLabel<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>" style="color: var(--text-color);">
                                        <?php if($operation->source_table == 'transactions'): ?>
                                            <?php echo e($operation->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat'); ?>

                                        <?php else: ?>
                                            <?php echo e($operation->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi'); ?>

                                        <?php endif; ?>
                                    </h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body" style="color: var(--text-color);">
                                    <p><strong>Sana:</strong> <?php echo e($operation->created_at->format('d.m.Y H:i')); ?></p>
                                    <p><strong>Summa:</strong> <?php echo e(number_format(abs($operation->amount), 2, '.', ' ')); ?> so‘m</p>
                                    <?php if($operation->type == 'payment_to_supplier'): ?>
                                        <p><strong>Manba:</strong> <?php echo e($operation->source == 'cash' ? 'Naqd' : 'Karta'); ?></p>
                                    <?php endif; ?>
                                    <p><strong>Izoh:</strong> <?php echo e($operation->description ?? 'Izoh yo‘q'); ?></p>
                                    <p><strong>Rasmlar:</strong>
                                        <?php
                                            $images = $operation->images ? json_decode($operation->images, true) : [];
                                        ?>
                                        <?php if(!empty($images) && is_array($images)): ?>
                                            <div class="image-grid d-flex flex-wrap">
                                                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <img src="<?php echo e(asset('storage/' . $image)); ?>" alt="Rasm" data-bs-toggle="modal" data-bs-target="#fullscreenModal<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>_<?php echo e($index); ?>">
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            Rasm yuklanmagan
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <div class="modal-footer">
                                    <?php if(auth()->user()->isAdmin() && $operation->source_table == 'payments' && !$operation->is_cancelled): ?>
                                        <form action="<?php echo e(route('payments.cancel', $operation->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('POST'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    <?php endif; ?>
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if(!empty($images) && is_array($images)): ?>
                        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="modal fade" id="fullscreenModal<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>_<?php echo e($index); ?>" tabindex="-1" aria-labelledby="fullscreenModalLabel<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>_<?php echo e($index); ?>" aria-hidden="true">
                                <div class="modal-dialog modal-fullscreen-sm-down">
                                    <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="fullscreenModalLabel<?php echo e($operation->source_table); ?>_<?php echo e($operation->id); ?>_<?php echo e($index); ?>" style="color: var(--text-color);">Rasm</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body text-center">
                                            <img id="fullscreen-image" src="<?php echo e(asset('storage/' . $image)); ?>" alt="Rasm">
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="mt-3 d-flex justify-content-center">
                    <?php echo e($operations->links('pagination::bootstrap-5')); ?>

                </div>
            <?php else: ?>
                <div class="text-center" style="color: var(--text-color);">Hozircha amaliyotlar yo‘q</div>
            <?php endif; ?>

            <a href="<?php echo e(route('suppliers.index')); ?>" class="btn btn-primary mt-3" style="background-color: var(--button-bg); color: var(--input-text); border: none;">Orqaga</a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/festasystems/paypul.datamax.uz/resources/views/suppliers/show.blade.php ENDPATH**/ ?>