<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Raqamlarni formatlash funksiyasi
        function formatNumber(number) {
            return Number(number).toLocaleString('uz-UZ', { minimumFractionDigits: 0 });
        }

        // Kalkulyator logikasini ishga tushirish funksiyasi
        function initializeCalculator() {
            const calculatorButtons = document.querySelectorAll('.calculator-btn');
            console.log('Calculator buttons found:', calculatorButtons.length);
            if (calculatorButtons.length === 0) {
                console.error('No calculator buttons found. Check if .calculator-btn class is applied correctly in HTML.');
                return;
            }

            calculatorButtons.forEach(button => {
                // Avvalgi click hodisalarini o'chirish
                button.removeEventListener('click', handleCalculatorClick);
                button.addEventListener('click', handleCalculatorClick);
            });
        }

        // Kalkulyator tugmasi uchun hodisa ishlovchisi
        function handleCalculatorClick(event) {
            event.preventDefault(); // Standart hodisani to'xtatish
            console.log('Calculator button clicked:', {
                value: this.getAttribute('data-value'),
                button: this
            });

            const cardBody = this.closest('.card-body');
            if (!cardBody) {
                console.error('Card body not found for button:', this);
                return;
            }

            const input = cardBody.querySelector('input[id$="_amount_display"]');
            const hiddenInput = cardBody.querySelector('input[name="amount"]');
            if (!input || !hiddenInput) {
                console.error('Input fields not found in card-body:', {
                    displayInput: !!input,
                    hiddenInput: !!hiddenInput
                });
                return;
            }

            const buttonValue = this.getAttribute('data-value');
            let currentValue = input.value.replace(/[^\d.]/g, '') || '0';

            if (buttonValue === 'clear') {
                input.value = '0';
                hiddenInput.value = '0';
            } else if (buttonValue === '000') {
                input.value = currentValue === '0' ? '0' : currentValue + '000';
                hiddenInput.value = input.value.replace(/[^\d.]/g, '');
                input.value = formatNumber(hiddenInput.value);
            } else if (buttonValue === '.') {
                if (!currentValue.includes('.')) {
                    input.value = currentValue === '0' ? '0.' : currentValue + '.';
                    hiddenInput.value = input.value.replace(/[^\d.]/g, '');
                }
            } else {
                if (currentValue === '0' && buttonValue !== '.') {
                    input.value = buttonValue;
                } else {
                    input.value = currentValue + buttonValue;
                }
                hiddenInput.value = input.value.replace(/[^\d.]/g, '');
                input.value = formatNumber(hiddenInput.value);
            }
            console.log('Calculator updated:', {
                display: input.value,
                hidden: hiddenInput.value
            });
        }

        // Dastlabki kalkulyatorni ishga tushirish
        initializeCalculator();

        // Tab o'zgarganda kalkulyatorni qayta ishga tushirish
        document.querySelectorAll('.nav-tabs .nav-link').forEach(tab => {
            tab.addEventListener('shown.bs.tab', function () {
                console.log('Tab switched:', this.getAttribute('data-bs-target'));
                initializeCalculator();
            });
        });
    });
</script>
<style>
    /* Kategoriya va Manba tugmalari dizayni */
    .category-btn, .manba-btn, .supplier-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 52px;
        font-size: 18px;
        border-radius: 12px;
        background: var(--input-bg);
        border: 1px solid var(--border-color);
        color: var(--input-text);
        transition: background-color 0.2s, color 0.2s;
        width: 100%;
        text-align: center;
    }
    .category-btn:hover, .manba-btn:hover, .supplier-btn:hover {
        background: var(--button-hover-bg);
        color: var(--button-text);
    }
    .category-btn i, .manba-btn i, .supplier-btn i {
        margin-right: 8px;
    }

    /* Kalkulyator dizayni */
    .calculator-keypad {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 12px;
        margin-top: 20px;
        padding: 15px;
        background: var(--card-bg);
        border-radius: 20px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }
    .calculator-keypad button {
        padding: 16px;
        font-size: 28px;
        font-weight: 600;
        border: none;
        border-radius: 50%;
        background: #333333;
        color: #ffffff;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        transition: transform 0.1s, background-color 0.2s, box-shadow 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
    }
    .calculator-keypad button:hover {
        background-color: #4a4a4a;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.4);
        transform: translateY(-1px);
    }
    .calculator-keypad button:active {
        transform: scale(0.95);
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
    }
    .calculator-keypad .clear-btn {
        background: #ff3b30;
        color: #ffffff;
    }
    .calculator-keypad .clear-btn:hover {
        background: #ff5e57;
    }
    .calculator-keypad .operator-btn {
        background: #ff9500;
        color: #ffffff;
    }
    .calculator-keypad .operator-btn:hover {
        background: #ffb347;
    }
    .calculator-keypad .zero-btn {
        grid-column: span 2;
        border-radius: 50px;
        padding: 16px 32px;
    }
    .calculator-keypad .btn-primary {
        background: var(--button-bg);
        border-radius: 50px;
        font-size: 24px;
        grid-column: span 2;
    }
    .calculator-keypad .btn-primary:hover {
        background: var(--button-hover-bg);
    }

    /* Umumiy dashboard dizayni */
    .card {
        border-radius: 20px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        background: var(--card-bg);
        border: 1px solid var(--border-color);
    }
    .form-control {
        font-size: 20px;
        padding: 14px;
        border-radius: 12px;
        border: 1px solid var(--border-color);
        background: var(--input-bg);
        color: var(--input-text);
    }
    .btn {
        font-size: 20px;
        padding: 14px;
        border-radius: 12px;
    }
    .nav-tabs {
        border: none;
        background: var(--nav-bg);
        border-radius: 12px;
        padding: 8px;
    }
    .nav-tabs .nav-link {
        font-size: 16px;
        padding: 10px 16px;
        border-radius: 10px;
        color: var(--nav-link);
        transition: background-color 0.2s, color 0.2s;
    }
    .nav-tabs .nav-link:hover {
        color: var(--nav-link-hover);
    }
    .nav-tabs .nav-link.active {
        background: var(--button-bg);
        color: var(--nav-link);
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    .form-label {
        font-size: 18px;
        font-weight: 600;
        color: var(--text-color);
    }
    input[type="text"], input[type="file"] {
        height: 52px;
    }
    .img-thumbnail {
        border-radius: 12px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    .tab-content {
        background: var(--card-bg);
        border-radius: 12px;
        padding: 15px;
        border: 1px solid var(--border-color);
    }

    /* Mobil uchun optimallashtirish */
    @media (max-width: 576px) {
        .calculator-keypad {
            gap: 10px;
            padding: 12px;
        }
        .calculator-keypad button {
            font-size: 24px;
            padding: 14px;
        }
        .calculator-keypad .btn-primary {
            font-size: 20px;
            padding: 14px 28px;
        }
        .form-control, .btn {
            font-size: 18px;
            padding: 12px;
        }
        .nav-tabs .nav-link {
            font-size: 14px;
            padding: 8px 12px;
        }
        .form-label {
            font-size: 16px;
        }
        .category-btn, .manba-btn, .supplier-btn {
            font-size: 16px;
            height: 48px;
        }
        input[type="text"], input[type="file"] {
            height: 48px;
        }
        .card {
            border-radius: 16px;
        }
    }
</style><?php /**PATH /home/festasystems/paypul.datamax.uz/resources/views/scripts_styles.blade.php ENDPATH**/ ?>