<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\HistoryController;
use App\Http\Controllers\TransactionController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    if (auth()->check()) {
        return redirect()->route('dashboard');
    }
    return redirect()->route('login');
});

Route::middleware(['auth', 'verified'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/dashboard/income', [DashboardController::class, 'storeIncome'])->name('dashboard.income.store');
    Route::post('/dashboard/transit-expense', [DashboardController::class, 'storeTransitExpense'])->name('dashboard.transit-expense.store');
    Route::post('/dashboard/payment-to-supplier', [DashboardController::class, 'storePaymentToSupplier'])->name('dashboard.payment-to-supplier.store');
    Route::post('/dashboard/product-payment', [DashboardController::class, 'storeProductPayment'])->name('dashboard.product-payment.store');

    // Profile routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::patch('/profile/password', [ProfileController::class, 'updatePassword'])->name('profile.update-password');

    // Suppliers
    Route::resource('suppliers', SupplierController::class);
    Route::post('/suppliers/{supplier}/return-product', [SupplierController::class, 'returnProduct'])->name('suppliers.return-product');

    // Categories
    Route::resource('categories', CategoryController::class);
    Route::get('/categories/expense/create', [CategoryController::class, 'expenseCreate'])->name('categories.expense.create');
    Route::post('/categories/expense', [CategoryController::class, 'storeExpense'])->name('categories.expense.store');

    // History
    Route::get('/history', [HistoryController::class, 'index'])->name('history.index');

    // Cancel routes
    Route::post('/transactions/{id}/cancel', [TransactionController::class, 'cancelTransaction'])->name('transactions.cancel');
    Route::post('/payments/{id}/cancel', [TransactionController::class, 'cancelPayment'])->name('payments.cancel');

    // Analytics (Placeholder)
    Route::get('/analytics', function () {
        return view('analytics.index');
    })->name('analytics.index');
});

require __DIR__.'/auth.php';