@extends('layouts.app')
@section('title', 'Yangi tranzit xarajat qo‘shish')
@section('content')
<div class="container">
    <h2 class="mb-4">Yangi tranzit xarajat qo‘shish</h2>
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('transit-expenses.store') }}">
                @csrf
                <div class="mb-3">
                    <label for="amount" class="form-label">Miqdor (so'm):</label>
                    <input type="text" name="amount" id="amount" class="form-control format-number @error('amount') is-invalid @enderror" value="{{ old('amount') }}" placeholder="1 000 000">
                    @error('amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-3">
                    <label class="form-label">Manba:</label>
                    <div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="source" value="cash" {{ old('source') == 'cash' ? 'checked' : '' }} id="source_cash">
                            <label class="form-check-label" for="source_cash">Naqd</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="source" value="card" {{ old('source') == 'card' ? 'checked' : '' }} id="source_card">
                            <label class="form-check-label" for="source_card">Karta</label>
                        </div>
                    </div>
                    @error('source')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Tavsif (ixtiyoriy):</label>
                    <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror">{{ old('description') }}</textarea>
                    @error('description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary">Saqlash</button>
                <a href="{{ route('transit-expenses.index') }}" class="btn btn-secondary">Bekor qilish</a>
            </form>
        </div>
    </div>
</div>
@endsection