<div class="card mt-4">
    <div class="card-header">
        <h5 class="mb-0">Amaliyotlar tarixi</h5>
    </div>
    <div class="card-body">
        @if($results)
            @forelse($results as $item)
                <div class="card mb-2" data-bs-toggle="modal" data-bs-target="#historyModal{{ $item->source_table }}_{{ $item->id }}">
                    <div class="card-body p-3" style="cursor: pointer;">
                        <div class="d-flex align-items-center">
                            <img src="{{ asset('assets/icons/' . ($item->source_table == 'transaction' ? ($item->type == 'income' ? 'income.png' : 'expense.png') : ($item->type == 'payment_to_supplier' ? 'payment_to_supplier.png' : 'product_payment.png'))) }}" alt="Icon" style="width: 24px; height: 24px; margin-right: 12px;">
                            <div>
                                <strong>
                                    @if ($item->source_table == 'transaction')
                                        {{ $item->type == 'income' ? 'Kirim' : 'Xarajat' }}
                                    @else
                                        {{ $item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot to‘lovi' }}
                                    @endif
                                </strong>
                                <div class="{{ $item->amount >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ number_format($item->amount, 2, '.', ' ') }} so‘m
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="historyModal{{ $item->source_table }}_{{ $item->id }}" tabindex="-1" aria-labelledby="historyModalLabel{{ $item->source_table }}_{{ $item->id }}" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="historyModalLabel{{ $item->source_table }}_{{ $item->id }}">Amaliyot tafsilotlari</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Turi:</strong>
                                    <span>
                                        @if ($item->source_table == 'transaction')
                                            {{ $item->type == 'income' ? 'Kirim' : 'Xarajat' }}
                                        @else
                                            {{ $item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot to‘lovi' }}
                                        @endif
                                    </span>
                                </p>
                                <p><strong>Miqdor:</strong> 
                                    <span class="{{ $item->amount >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($item->amount, 2, '.', ' ') }} so‘m
                                    </span>
                                </p>
                                <p><strong>Manba:</strong> 
                                    <span>{{ $item->source == 'cash' ? 'Naqd' : 'Karta' }}</span>
                                </p>
                                <p><strong>Yetkazib beruvchi:</strong> 
                                    <span>{{ $item->supplier_name ?? 'N/A' }}</span>
                                </p>
                                <p><strong>Kategoriya:</strong> 
                                    <span>{{ $item->related_entity ?? 'N/A' }}</span>
                                </p>
                                <p><strong>Tavsif:</strong> 
                                    <span>{{ $item->description ?? 'N/A' }}</span>
                                </p>
                                <p><strong>Sana:</strong> 
                                    <span>{{ $item->created_at->format('Y-m-d H:i') }}</span>
                                </p>
                                <p><strong>Rasmlar:</strong>
                                    @if ($item->images && is_array(json_decode($item->images, true)) && count(json_decode($item->images, true)) > 0)
                                        <div id="carousel{{ $item->source_table }}_{{ $item->id }}" class="carousel slide" data-bs-ride="carousel">
                                            <div class="carousel-inner">
                                                @foreach (json_decode($item->images, true) as $index => $image)
                                                    <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                                                        <img src="{{ asset('storage/' . $image) }}" class="d-block w-100" alt="Rasm" style="max-height: 300px; object-fit: contain;">
                                                    </div>
                                                @endforeach
                                            </div>
                                            @if (count(json_decode($item->images, true)) > 1)
                                                <button class="carousel-control-prev" type="button" data-bs-target="#carousel{{ $item->source_table }}_{{ $item->id }}" data-bs-slide="prev">
                                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                                    <span class="visually-hidden">Previous</span>
                                                </button>
                                                <button class="carousel-control-next" type="button" data-bs-target="#carousel{{ $item->source_table }}_{{ $item->id }}" data-bs-slide="next">
                                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                                    <span class="visually-hidden">Next</span>
                                                </button>
                                            @endif
                                        </div>
                                    @else
                                        Rasm yuklanmagan
                                    @endif
                                </p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="text-center">Hozircha amaliyotlar yo‘q</div>
            @endforelse
        @else
            <div class="text-center">Hozircha amaliyotlar yo‘q</div>
        @endif

        <div class="mt-3">
            {{ $results->links() ?? '' }}
        </div>
    </div>
</div>