@extends('layouts.app')
@section('title', 'Yetkazib beruvchilar')

@section('content')
<style>
    .list-group-item {
        transition: all 0.2s ease;
        border-radius: 8px !important;
        margin-bottom: 12px;
        border: 1px solid #dee2e6;
        padding: 15px;
        background-color: var(--bs-body-bg, #fff);
        color: var(--bs-body-color, #212529);
    }
    .list-group-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.05);
        background-color: var(--bs-light, #f8f9fa);
    }
    .supplier-name {
        font-size: 1.1rem;
        font-weight: 500;
    }
    .supplier-balance {
        font-size: 1rem;
        font-weight: 600;
    }
    [data-bs-theme="dark"] .list-group-item {
        background-color: #343a40;
        border-color: #495057;
        color: #f8f9fa;
    }
    [data-bs-theme="dark"] .list-group-item:hover {
        background-color: #495057;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.2);
    }
    @media (max-width: 576px) {
        .list-group-item {
            padding: 12px;
        }
        .supplier-name {
            font-size: 0.95rem;
        }
        .supplier-balance {
            font-size: 0.9rem;
        }
    }
</style>

<div class="container mt-4">
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">
               Balans: 
                <span class="text-danger">Qarzdorlik: {{ number_format(abs($weOweBalance), 0, '.', ' ') }} so‘m</span>
                <span class="text-success"> | Qoldiq: {{ number_format($theyOweBalance, 0, '.', ' ') }} so‘m</span>
            </h5>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header">
            <button class="btn btn-outline-primary btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#filterCollapse" aria-expanded="false" aria-controls="filterCollapse" id="filterToggleBtn">
                Filtrlarni ko‘rsatish
            </button>
        </div>
        <div class="collapse" id="filterCollapse">
            <div class="card-body">
                <form method="GET" action="{{ route('suppliers.index') }}">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="user_id" class="form-label">Biriktirilgan shaxs</label>
                            <select name="user_id" id="user_id" class="form-control">
                                <option value="">Hammasi</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="debt_type" class="form-label">Qarz holati</label>
                            <select name="debt_type" id="debt_type" class="form-control">
                                <option value="">Hammasi</option>
                                <option value="we_owe" {{ request('debt_type') == 'we_owe' ? 'selected' : '' }}>Qarzmiz</option>
                                <option value="they_owe" {{ request('debt_type') == 'they_owe' ? 'selected' : '' }}>Qarz emasmiz</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="date" class="form-label">Sana (dan boshlab)</label>
                            <input type="date" name="date" id="date" class="form-control" value="{{ request('date') }}">
                        </div>
                    </div>
                    <div class="d-flex justify-content-between">
                        <button type="submit" class="btn btn-primary btn-sm">Filtrlash</button>
                        <a href="{{ route('suppliers.index') }}" class="btn btn-secondary btn-sm">Tozalash</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Yetkazib beruvchilar ro‘yxati</h5>
            <a href="{{ route('suppliers.create') }}" class="btn btn-primary btn-sm float-end">Yangi qo‘shish</a>
        </div>
        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="list-group">
                @forelse($suppliers as $supplier)
                    <a href="{{ route('suppliers.show', $supplier->id) }}" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between align-items-center">
                            <h5 class="mb-0 supplier-name">{{ $supplier->name }}</h5>
                            <span class="supplier-balance {{ $supplier->debt_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($supplier->debt_balance, 0, '.', ' ') }} so‘m
                            </span>
                        </div>
                    </a>
                @empty
                    <div class="list-group-item text-center">
                        Yetkazib beruvchilar topilmadi
                    </div>
                @endforelse
            </div>

            <div class="mt-4">
                {{ $suppliers->appends(request()->query())->links('pagination::bootstrap-5-custom') }}
            </div><br><br><br>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const filterToggleBtn = document.getElementById('filterToggleBtn');
        const filterCollapse = document.getElementById('filterCollapse');

        filterCollapse.addEventListener('show.bs.collapse', function () {
            filterToggleBtn.textContent = 'Filtrlarni yashirish';
        });

        filterCollapse.addEventListener('hide.bs.collapse', function () {
            filterToggleBtn.textContent = 'Filtrlarni ko‘rsatish';
        });
    });
</script>
@endsection