@extends('layouts.app')

@section('title', 'Profilni Tahrirlash')

@section('content')
<div class="container mt-4">
    <div class="card" style="background-color: var(--card-bg); border: 1px solid var(--border-color);">
        <div class="card-body">
            <h2 class="card-title" style="color: var(--text-color);">Profil</h2>

            <!-- Parolni almashtirish formasi -->
            <h4 class="mt-4" style="color: var(--text-color);">Parolni Almashtirish</h4>
            @if (session('success'))
                <div class="alert alert-success" style="background-color: var(--alert-success-bg); color: var(--text-color);">
                    {{ session('success') }}
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger" style="background-color: var(--alert-danger-bg); color: var(--text-color);">
                    {{ session('error') }}
                </div>
            @endif

            <form method="POST" action="{{ route('profile.update-password') }}">
                @csrf
                @method('PATCH')

                <!-- Joriy parol -->
                <div class="mb-3">
                    <label for="current_password" class="form-label">Joriy Parol</label>
                    <input type="password" name="current_password" id="current_password" class="form-control @error('current_password') is-invalid @enderror" style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);" required>
                    @error('current_password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Yangi parol -->
                <div class="mb-3">
                    <label for="password" class="form-label">Yangi Parol</label>
                    <input type="password" name="password" id="password" class="form-control @error('password') is-invalid @enderror" style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);" required>
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Yangi parolni tasdiqlash -->
                <div class="mb-3">
                    <label for="password_confirmation" class="form-label">Yangi Parolni Tasdiqlash</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);" required>
                    @error('password_confirmation')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <button type="submit" class="btn btn-primary" style="background-color: var(--button-bg); color: var(--input-text); border: none;">Parolni Almashtirish</button>
            </form>
        </div>
    </div>
</div>
@endsection