@extends('layouts.app')
@section('title', 'Kirimlar')
@section('content')
<div class="container">
    <h2 class="mb-4">Kirimlar</h2>
    <a href="{{ route('income.create') }}" class="btn btn-primary mb-3">Yangi kirim qo‘shish</a>
    <div class="card">
        <div class="card-body">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Kategoriya</th>
                        <th>Miqdor (so'm)</th>
                        <th>Manba</th>
                        <th>Tavsif</th>
                        <th>Sana</th>
                        <th>Amallar</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($incomes as $income)
                    <tr>
                        <td>{{ $income->category }}</td>
                        <td class="format-number">{{ $income->amount }}</td>
                        <td>{{ $income->source == 'cash' ? 'Naqd' : 'Karta' }}</td>
                        <td>{{ $income->description ?? '-' }}</td>
                        <td>{{ $income->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            <a href="{{ route('income.edit', $income->id) }}" class="btn btn-sm btn-primary">Tahrirlash</a>
                            <form action="{{ route('income.destroy', $income->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('O‘chirishni tasdiqlaysizmi?')">O‘chirish</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">Hozircha kirimlar yo‘q</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection