@extends('layouts.app')
@section('title', 'Tarix')

@section('content')
<style>
    .image-grid img {
        max-width: 100px;
        margin: 5px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        cursor: pointer;
        transition: transform 0.2s;
    }
    .image-grid img:hover {
        transform: scale(1.05);
    }
    #fullscreen-image {
        max-width: 100%;
        max-height: 80vh;
        object-fit: contain;
    }
    .pagination .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-text);
        border-color: var(--border-color);
        transition: background-color 0.2s, color 0.2s;
    }
    .pagination .page-link:hover {
        background-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.active .page-link {
        background-color: var(--pagination-active-bg);
        border-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.disabled .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-disabled);
        border-color: var(--border-color);
    }
</style>

<div class="container mt-4">
    <div class="card" style="background-color: var(--card-bg); border: 1px solid var(--border-color);">
        <div class="card-header">
            <h5 class="mb-0" style="color: var(--text-color);">Barcha amaliyotlar tarixi</h5>
        </div>
        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert" style="background-color: var(--alert-success-bg); color: var(--text-color);">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert" style="background-color: var(--alert-danger-bg); color: var(--text-color);">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @forelse($results as $item)
                <div class="card mb-2 history-card" data-bs-toggle="modal" data-bs-target="#historyModal{{ $item->source_table }}_{{ $item->id }}" data-history-id="{{ $item->source_table }}_{{ $item->id }}">
                    <div class="card-body p-3" style="cursor: pointer;">
                        <div class="d-flex align-items-center">
                            <img src="{{ asset('assets/icons/' . ($item->source_table == 'transactions' ? ($item->type == 'income' ? 'income.png' : ($item->type == 'product_return' ? 'product_return.png' : 'expense.png')) : ($item->type == 'payment_to_supplier' ? 'payment_to_supplier.png' : 'product_payment.png'))) }}" alt="Icon" style="width: 24px; height: 24px; margin-right: 12px;">
                            <div>
                                <strong style="color: var(--text-color);">
                                    @if ($item->source_table == 'transactions')
                                        {{ $item->type == 'income' ? 'Kirim' : ($item->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat') }}
                                    @else
                                        {{ $item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi' }}
                                    @endif
                                    @if ($item->is_cancelled)
                                        <span class="badge bg-danger">Bekor qilindi</span>
                                    @endif
                                </strong>
                                <div class="{{ $item->amount >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ number_format(abs($item->amount), 2, '.', ' ') }} so‘m
                                </div>
                                <small class="text-muted" style="color: var(--text-muted);">
                                    {{ $item->created_at->format('d.m.Y H:i') }}
                                    @if ($item->user)
                                        | {{ $item->user->name }}
                                    @endif
                                    @if ($item->source_table == 'transactions' && $item->category)
                                        | {{ $item->category->name }}
                                    @endif
                                    @if ($item->source_table == 'payments' && $item->supplier)
                                        | {{ $item->supplier->name }}
                                    @endif
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Modal -->
                <div class="modal fade" id="historyModal{{ $item->source_table }}_{{ $item->id }}" tabindex="-1" aria-labelledby="historyModalLabel{{ $item->source_table }}_{{ $item->id }}" aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                            <div class="modal-header">
                                <h5 class="modal-title" id="historyModalLabel{{ $item->source_table }}_{{ $item->id }}" style="color: var(--text-color);">
                                    @if ($item->source_table == 'transactions')
                                        {{ $item->type == 'income' ? 'Kirim' : ($item->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat') }}
                                    @else
                                        {{ $item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi' }}
                                    @endif
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body" style="color: var(--text-color);">
                                <p><strong>Sana:</strong> {{ $item->created_at->format('d.m.Y H:i') }}</p>
                                <p><strong>Summa:</strong> {{ number_format(abs($item->amount), 2, '.', ' ') }} so‘m</p>
                                <p><strong>Manba:</strong> {{ $item->source == 'cash' ? 'Naqd' : 'Karta' }}</p>
                                @if ($item->source_table == 'transactions' && $item->category)
                                    <p><strong>Kategoriya:</strong> {{ $item->category->name }}</p>
                                @endif
                                @if ($item->source_table == 'payments' && $item->supplier)
                                    <p><strong>Yetkazib beruvchi:</strong> {{ $item->supplier->name }}</p>
                                @endif
                                @if ($item->source_table == 'transactions' && $item->supplier)
                                    <p><strong>Yetkazib beruvchi:</strong> {{ $item->supplier->name }}</p>
                                @endif
                                <p><strong>Izoh:</strong> {{ $item->description ?? 'Izoh yo‘q' }}</p>
                                <p><strong>Rasmlar:</strong>
                                    @php
                                        $images = $item->images ? json_decode($item->images, true) : [];
                                    @endphp
                                    @if (!empty($images) && is_array($images))
                                        <div class="image-grid d-flex flex-wrap">
                                            @foreach ($images as $index => $image)
                                                <img src="{{ asset('storage/' . $image) }}" alt="Rasm" data-bs-toggle="modal" data-bs-target="#fullscreenModal{{ $item->source_table }}_{{ $item->id }}_{{ $index }}">
                                            @endforeach
                                        </div>
                                    @else
                                        Rasm yuklanmagan
                                    @endif
                                </p>
                            </div>
                            <div class="modal-footer">
                                @if (auth()->user()->isAdmin() && !$item->is_cancelled)
                                    @if ($item->source_table == 'transactions' && $item->type != 'income' && $item->type != 'product_return')
                                        <form action="{{ route('transactions.cancel', $item->id) }}" method="POST">
                                            @csrf
                                            @method('POST')
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    @elseif ($item->source_table == 'payments')
                                        <form action="{{ route('payments.cancel', $item->id) }}" method="POST">
                                            @csrf
                                            @method('POST')
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    @endif
                                @endif
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                            </div>
                        </div>
                    </div>
                </div>

                @php
                    $images = $item->images ? json_decode($item->images, true) : [];
                @endphp
                @if (!empty($images) && is_array($images))
                    @foreach ($images as $index => $image)
                        <div class="modal fade" id="fullscreenModal{{ $item->source_table }}_{{ $item->id }}_{{ $index }}" tabindex="-1" aria-labelledby="fullscreenModalLabel{{ $item->source_table }}_{{ $item->id }}_{{ $index }}" aria-hidden="true">
                            <div class="modal-dialog modal-fullscreen-sm-down">
                                <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="fullscreenModalLabel{{ $item->source_table }}_{{ $item->id }}_{{ $index }}" style="color: var(--text-color);">Rasm</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <img id="fullscreen-image" src="{{ asset('storage/' . $image) }}" alt="Rasm">
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            @empty
                <div class="text-center" style="color: var(--text-color);">Hozircha amaliyotlar yo‘q</div>
            @endforelse

            <div class="mt-3 d-flex justify-content-center">
                {{ $results->links('pagination::bootstrap-5') }}
            </div><br><br><br>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    // Initialize Bootstrap modals and store instances
    const modals = document.querySelectorAll('.modal');
    const modalInstances = new Map();

    modals.forEach(modal => {
        modalInstances.set(modal.id, new bootstrap.Modal(modal, { backdrop: true, keyboard: true }));
        
        // Log modal open events for debugging
        modal.addEventListener('shown.bs.modal', () => {
            console.log(`Modal ${modal.id} opened`);
        });

        // Handle modal close to ensure proper cleanup
        modal.addEventListener('hidden.bs.modal', () => {
            console.log(`Modal ${modal.id} closed`);
            
            // Clean up modal backdrop and body classes
            const backdrops = document.querySelectorAll('.modal-backdrop');
            backdrops.forEach(backdrop => backdrop.remove());
            document.body.classList.remove('modal-open');
            document.body.style.overflow = '';
            document.body.style.paddingRight = '';

            // Reset modal state
            modal.removeAttribute('aria-hidden');
            modal.removeAttribute('aria-modal');
            modal.style.display = '';
            modal.classList.remove('show');

            // Restore focus and re-enable historyModal card
            let historyModalId = modal.id;
            if (modal.id.includes('fullscreenModal')) {
                historyModalId = modal.id.replace(/fullscreenModal/, 'historyModal').replace(/_\d+$/, '');
                const historyModal = document.getElementById(historyModalId);
                if (historyModal) {
                    historyModal.removeAttribute('aria-hidden');
                    historyModal.removeAttribute('aria-modal');
                    historyModal.style.display = '';
                    historyModal.classList.remove('show');
                    console.log(`Reset state for ${historyModalId}`);
                }
            }

            const relatedCard = document.querySelector(`[data-bs-target="#${historyModalId}"]`);
            if (relatedCard) {
                // Reinitialize Bootstrap Modal for historyModal to ensure it can be reopened
                if (historyModalId.includes('historyModal')) {
                    modalInstances.set(historyModalId, new bootstrap.Modal(document.getElementById(historyModalId), { backdrop: true, keyboard: true }));
                }
                relatedCard.focus();
                console.log(`Focus restored and modal reinitialized for ${historyModalId}`);
            } else {
                document.body.focus();
                console.log('Focus restored to body');
            }
        });
    });
});
</script>
@endsection