@extends('layouts.app')

@section('content')
<div class="auth-container">
    <h2 class="text-center">Ro'yxatdan o'tish</h2>

    <form method="POST" action="{{ route('register') }}">
        @csrf

        <div class="mb-3">
            <label for="name" class="form-label"><i class="bi bi-person-fill me-2"></i>Ism</label>
            <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autofocus autocomplete="name">
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="phone" class="form-label"><i class="bi bi-phone-fill me-2"></i>Telefon raqam</label>
            <input id="phone" type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}" required autocomplete="tel">
            @error('phone')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="password" class="form-label"><i class="bi bi-lock-fill me-2"></i>Parol</label>
            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
            @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="password-confirm" class="form-label"><i class="bi bi-lock-fill me-2"></i>Parolni tasdiqlang</label>
            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
        </div>

        <div class="d-grid">
            <button type="submit" class="btn btn-primary">Hisob yaratish</button>
        </div>

        @if (Route::has('login'))
            <div class="text-center mt-3">
                <a class="btn btn-link" href="{{ route('login') }}">
                  Hisobingiz bormi?
                </a>
            </div>
        @endif
    </form>
</div>
@endsection