<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            // type maydonini yangilash
            $table->enum('type', ['income', 'transit_expense', 'product_return'])->change();
            // supplier_id qo‘shish
            $table->foreignId('supplier_id')->nullable()->constrained()->onDelete('cascade');
            // images maydoni qo‘shish (agar yo‘q bo‘lsa)
            if (!Schema::hasColumn('transactions', 'images')) {
                $table->json('images')->nullable();
            }
            // is_cancelled va cancelled_at qo‘shish (agar yo‘q bo‘lsa)
            if (!Schema::hasColumn('transactions', 'is_cancelled')) {
                $table->boolean('is_cancelled')->default(false);
            }
            if (!Schema::hasColumn('transactions', 'cancelled_at')) {
                $table->timestamp('cancelled_at')->nullable();
            }
        });
    }

    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            // O‘zgarishlarni qaytarish
            $table->enum('type', ['income', 'transit_expense'])->change();
            $table->dropForeign(['supplier_id']);
            $table->dropColumn('supplier_id');
            if (Schema::hasColumn('transactions', 'images')) {
                $table->dropColumn('images');
            }
            if (Schema::hasColumn('transactions', 'is_cancelled')) {
                $table->dropColumn('is_cancelled');
            }
            if (Schema::hasColumn('transactions', 'cancelled_at')) {
                $table->dropColumn('cancelled_at');
            }
        });
    }
};