<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Category; // Add this line (adjust namespace if different)

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->string('type')->default('expense')->after('name');
        });

        // Assign type to existing categories
        Category::whereIn('name', ['Kassadan', 'Tashqi mablag\'', 'Savdo'])->update(['type' => 'income']);
        Category::where('name', 'Boshqa')->update(['type' => 'expense']);
    }

    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
};