<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class ProfileController extends Controller
{
    public function edit()
    {
        return view('profile.edit');
    }

    public function update(Request $request)
    {
        // Foydalanuvchi ma'lumotlarini yangilash logikasi (mavjud bo'lsa)
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users,email,' . Auth::id()],
        ]);

        Auth::user()->update($request->only('name', 'email'));

        return back()->with('success', 'Profil muvaffaqiyatli yangilandi.');
    }

    public function destroy(Request $request)
    {
        // Foydalanuvchi hisobini o'chirish logikasi (mavjud bo'lsa)
        $request->validateWithBag('userDeletion', [
            'password' => ['required', 'current_password'],
        ]);

        $user = Auth::user();
        Auth::logout();
        $user->delete();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/');
    }

    public function updatePassword(Request $request)
    {
        $request->validate([
            'current_password' => ['required', 'string', 'current_password'],
            'password' => ['required', 'confirmed', Password::min(8)],
            'password_confirmation' => ['required'],
        ]);

        $user = Auth::user();

        // Joriy parolni tekshirish
        if (!Hash::check($request->current_password, $user->password)) {
            return back()->withErrors(['current_password' => 'Joriy parol noto‘g‘ri.']);
        }

        // Yangi parolni saqlash
        $user->password = Hash::make($request->password);
        $user->save();

        return back()->with('success', 'Parol muvaffaqiyatli yangilandi.');
    }
}